# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdtypevector import SDTypeVector
from .sdapiobject import SDAPIObject
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDTypeBool4(SDTypeVector):
    """
    Class representing the bool4 type
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDTypeBool4
        """
        super(SDTypeBool4, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew() -> SDTypeBool4:
        """
        Create new SDTypeBool4

        """
        outSDTypeBool4 = ctypes.c_void_p()
        _res = sd.getContext().SDTypeBool4_sNew(ctypes.byref(outSDTypeBool4))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDTypeBool4, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDTypeBool4.value, ownHandle=True)

